
// ========== Generated With RFC Amalgamator v1.0 ==========

#ifndef _RFC_AMALGAMATED_H_
#define _RFC_AMALGAMATED_H_ 

#define AMALGAMATED_VERSION
#define _CRT_SECURE_NO_WARNINGS

// =========== config.h ===========

#ifndef _CONFIG_H_
#define _CONFIG_H_

#ifdef AMALGAMATED_VERSION
	#define RFC_API
#else
	#ifdef _MSC_VER // M$ compiler
		#ifdef RFC_STATIC_APP
			#define RFC_API 
		#else
			#ifdef RFC_DLL
				#define RFC_API __declspec(dllexport)
			#else
				#define RFC_API __declspec(dllimport)
				#pragma comment(lib,"rfc025.lib")
			#endif
		#endif
	#else // non M$ compilers must use entire source code or amalgamated version.
		#define RFC_API 
	#endif
#endif


#ifdef _WIN64
	#define RFC64
	#define PTR_SIZE 8
	#define NATIVE_INT __int64
#else
	#define RFC32
	#define PTR_SIZE 4
	#define NATIVE_INT int
#endif


#endif

// =========== KListBoxListener.h ===========

/*
    RFC - KListBoxListener.h
    Copyright (C) 2013-2016 CrownSoft
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#ifndef _RFC_KLISTBOXLISTENER_H_
#define _RFC_KLISTBOXLISTENER_H_


class KListBox;

class RFC_API KListBoxListener
{
public:
	KListBoxListener();
	virtual ~KListBoxListener();

	virtual void OnListBoxItemSelect(KListBox *listBox);
};

#endif

// =========== KPointerList.h ===========

/*
    RFC - KPointerList.h
    Copyright (C) 2013-2016 CrownSoft
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/


#ifndef _RFC_KPOINTERLIST_H_
#define _RFC_KPOINTERLIST_H_

#include<malloc.h>
#include<windows.h>

#if defined(_MSC_VER) && _MSC_VER > 1000
#pragma warning(disable:4311)
#pragma warning(disable:4312)
#endif


/**
	Holds a resizable list of pointers.
	To make all the methods thread-safe, pass true for isThreadSafe parameter of constructor.
	Duplicated items allowed!
	index is between 0 to (item count-1)

	e.g. @code
	KButton btn1;
	KPointerList<KButton*> btnList(1024,true);
	btnList.AddPointer(&btn1);
	btnList.AddPointer(&btn1);
	@endcode
*/
template<class T>
class KPointerList
{
protected:
	int size;
	int roomCount;
	int roomIncrement;
	void* list;

	CRITICAL_SECTION criticalSection;
	bool isThreadSafe;
public:
	/**
		Constructs PointerList object.
		@param roomIncrement initial and reallocation size of internal memory block in DWORDS
		@param isThreadSafe make all the methods thread-safe
	*/
	KPointerList(int roomIncrement=1024,bool isThreadSafe=false) // 1024*4=4096 = default alignment!
	{
		roomCount=roomIncrement;
		this->roomIncrement=roomIncrement;
		this->isThreadSafe=isThreadSafe;
		size=0;
		list = ::malloc(roomCount*PTR_SIZE);
		
		if(isThreadSafe)
		{
			::InitializeCriticalSection(&criticalSection);
		}
	}

	/**
		Adds new item to the list.
		@returns false if memory allocation failed!
	*/
	bool AddPointer(T pointer)
	{
		if(isThreadSafe)
		{
			::EnterCriticalSection(&criticalSection); // thread safe!
		}

		if(roomCount>=(size+1)) // no need reallocation. coz room count is enough!
		{
			*(NATIVE_INT*)((NATIVE_INT)list + (size * PTR_SIZE)) = (NATIVE_INT)pointer;

			size++;
			if(isThreadSafe)
			{
				::LeaveCriticalSection(&criticalSection);
			}
			return true;
		}else // require reallocation!
		{
			roomCount+=roomIncrement;
			void* retVal = ::realloc(list, roomCount*PTR_SIZE); 
			if(retVal)
			{
				list=retVal;

				*(NATIVE_INT*)((NATIVE_INT)list + (size * PTR_SIZE)) = (NATIVE_INT)pointer;

				size++;
				if(isThreadSafe)
				{
					::LeaveCriticalSection(&criticalSection);
				}
				return true;
			}else // memory allocation failed!
			{
				if(isThreadSafe)
				{
					::LeaveCriticalSection(&criticalSection);
				}
				return false;
			}
		}
	}

	/**
		Get pointer at id.
		@returns 0 if id is out of range!
	*/
	T GetPointer(int id)
	{
		if(isThreadSafe)
		{
			::EnterCriticalSection(&criticalSection);
		}

		if( (0<=id) & (id<size) ) // checks for valid range!
		{	
			T object = (T)(*(NATIVE_INT*)((NATIVE_INT)list + (id*PTR_SIZE)));
			if(isThreadSafe)
			{
				::LeaveCriticalSection(&criticalSection);
			}
			return object;
		}else // out of range!
		{
			if(isThreadSafe)
			{
				::LeaveCriticalSection(&criticalSection);
			}
			return 0;
		}
	}

	/**
		Replace pointer of given id with new pointer
		@returns false if id is out of range!
	*/
	bool SetPointer(int id,T pointer)
	{
		if(isThreadSafe)
		{
			::EnterCriticalSection(&criticalSection);
		}
		if( (0<=id) & (id<size) )
		{			
			*(NATIVE_INT*)((NATIVE_INT)list + (id * PTR_SIZE)) = (NATIVE_INT)pointer;
			if(isThreadSafe)
			{
				::LeaveCriticalSection(&criticalSection);
			}
			return true;
		}else // out of range!
		{
			if(isThreadSafe)
			{
				::LeaveCriticalSection(&criticalSection);
			}
			return false;
		}
	}

	/**
		Remove pointer of given id
		@returns false if id is out of range!
	*/
	bool RemovePointer(int id)
	{
		if(isThreadSafe)
		{
			::EnterCriticalSection(&criticalSection);
		}
		if( (0<=id) & (id<size) )
		{	
			int newRoomCount=(((size-1)/roomIncrement)+1)*roomIncrement;
			void* newList = ::malloc(newRoomCount*PTR_SIZE);

			for(register int i=0,j=0;i<size;i++)
			{
				if(i!=id)
				{
					*(NATIVE_INT*)((NATIVE_INT)newList + (j*PTR_SIZE)) = *(NATIVE_INT*)((NATIVE_INT)list + (i * PTR_SIZE));
					j++;
				}	
			}
			::free(list); // free old list!
			list=newList;
			roomCount=newRoomCount;
			size--;
			if(isThreadSafe)
			{
				::LeaveCriticalSection(&criticalSection);
			}
			return true;

		}else // out of range!
		{
			if(isThreadSafe)
			{
				::LeaveCriticalSection(&criticalSection);
			}
			return false;
		}

	}

	/**
		Clears the list!
	*/
	void RemoveAll()// remove all pointers from list!
	{
		if(isThreadSafe)
		{
			::EnterCriticalSection(&criticalSection);
		}
		::free(list);
		roomCount=roomIncrement;
		list == ::malloc(roomCount*PTR_SIZE);
		size=0;
		if(isThreadSafe)
		{
			::LeaveCriticalSection(&criticalSection);
		}
	}

	/**
		Call destructors of all objects which are pointed by pointers in the list.
		Also clears the list.
	*/
	void DeleteAll()
	{
		if(isThreadSafe)
		{
			::EnterCriticalSection(&criticalSection);
		}
		for(int i=0;i<size;i++)
		{
			T object = (T)(*(NATIVE_INT*)((NATIVE_INT)list + (i*PTR_SIZE)));
			delete object;
		}

		::free(list);
		roomCount=roomIncrement;
		list = ::malloc(roomCount*PTR_SIZE);
		size=0;
		if(isThreadSafe)
		{
			::LeaveCriticalSection(&criticalSection);
		}
	}

	/**
		Finds the id of the first pointer which matches the pointer passed in.
		@returns -1 if not found!
	*/
	int GetID(T pointer)
	{
		if(isThreadSafe)
		{
			::EnterCriticalSection(&criticalSection);
		}
		for(register int i=0;i<size;i++)
		{
			if (*(NATIVE_INT*)((NATIVE_INT)list + (i*PTR_SIZE)) == (NATIVE_INT)pointer)
			{
				if(isThreadSafe)
				{
					::LeaveCriticalSection(&criticalSection);
				}
				return i;
			}
		}
		if(isThreadSafe)
		{
			::LeaveCriticalSection(&criticalSection);
		}
		return -1;
	}

	/**
		@returns item count in the list
	*/
	int GetSize()
	{
		return size;
	}

	/** Destructs PointerList object.*/
	~KPointerList()
	{
		::free(list);
		if(isThreadSafe)
		{
			::DeleteCriticalSection(&criticalSection);
		}
	}

};

#endif

// =========== KMenuItemListener.h ===========

/*
    RFC - KMenuItemListener.h
    Copyright (C) 2013-2016 CrownSoft
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#ifndef _RFC_KMENUITEMLISTENER_H_
#define _RFC_KMENUITEMLISTENER_H_


class KMenuItem;

class RFC_API KMenuItemListener
{
public:
	KMenuItemListener();
	virtual ~KMenuItemListener();

	virtual void OnMenuItemPress(KMenuItem *menuItem);
};

#endif

// =========== KTrackBarListener.h ===========

/*
    RFC - KTrackBarListener.h
    Copyright (C) 2013-2016 CrownSoft
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#ifndef _RFC_KTRACKBARLISTENER_H_
#define _RFC_KTRACKBARLISTENER_H_


class KTrackBar;

class RFC_API KTrackBarListener
{
public:
	KTrackBarListener();
	virtual ~KTrackBarListener();

	virtual void OnTrackBarChange(KTrackBar *trackBar);
};

#endif

// =========== KButtonListener.h ===========

/*
    RFC - KButtonListener.h
    Copyright (C) 2013-2016 CrownSoft
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#ifndef _RFC_KBUTTONLISTENER_H_
#define _RFC_KBUTTONLISTENER_H_


class KButton;

class RFC_API KButtonListener
{
public:
	KButtonListener();
	virtual ~KButtonListener();

	virtual void OnButtonPress(KButton *button);
};

#endif

// =========== KThread.h ===========

/*
    RFC - KThread.h
    Copyright (C) 2013-2016 CrownSoft
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#ifndef _RFC_KTHREAD_H_
#define _RFC_KTHREAD_H_

#include<windows.h>

/**
    Encapsulates a thread.

    Subclasses derive from KThread and implement the Run() method, in which they
    do their business. The thread can then be started with the StartThread() method
    and controlled with various other methods.

	Run() method implementation might be like this
	@code
	virtual void Run()
	{
		while(!threadShouldStop)
		{
			// your code goes here...
		}
		isThreadRunning=false;	
	}
	@endcode

*/
class RFC_API KThread
{
protected:
	HANDLE handle;
	volatile bool isThreadRunning;
	volatile bool threadShouldStop;
public:
	KThread();

	/**
		Sets thread handle.
	*/
	virtual void SetHandle(HANDLE handle);

	/**
		Returns handle of the thread
	*/
	virtual HANDLE GetHandle();

	/**
		Override this method in your class.
	*/
	virtual void Run();

	/**
		Starts thread
	*/
	virtual bool StartThread();

	/**
		Another thread can signal this thread should stop. 
	*/
	virtual void ThreadShouldStop();

	/**
		@returns true if thread is still running
	*/
	virtual bool IsThreadRunning();

	/**
		Calling thread is not return until this thread finish.
	*/
	virtual void WaitUntilThreadFinish();

	virtual ~KThread();
};

#endif

// =========== KTimerListener.h ===========


/*
    RFC - KTimerListener.h
    Copyright (C) 2013-2016 CrownSoft
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#ifndef _RFC_KTIMER_LISTENER_H_
#define _RFC_KTIMER_LISTENER_H_


class KTimer;

class RFC_API KTimerListener
{
public:
	KTimerListener();
	virtual ~KTimerListener();

	virtual void OnTimer(KTimer *timer);
};

#endif

// =========== KStringHolder.h ===========


/*
    RFC - KString.h
    Copyright (C) 2013-2016 CrownSoft
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#ifndef _RFC_KSTRINGHOLDER_H_
#define _RFC_KSTRINGHOLDER_H_

#include<windows.h>


/**
	This class holds reference counted string.
*/
class RFC_API KStringHolder
{
	volatile LONG refCount;
	char *a_text; // ansi version
	CRITICAL_SECTION cs_a_text; // to guard ansi string creation
public:
	wchar_t *w_text; // unicode version
	int count; // character count

	KStringHolder();

	~KStringHolder();

	/**
		Make sure to call this method if you contruct new KStringHolder or keep reference to another KStringHolder object.
	*/
	void AddReference();

	/**
		Make sure to call this method if you clear reference to KStringHolder object. it will release allocated memory for string.
	*/
	void ReleaseReference();

	/**
		ANSI version available only when needed.
	*/
	const char* GetAnsiVersion();
};

#endif

// =========== KComboBoxListener.h ===========

/*
    RFC - KComboBoxListener.h
    Copyright (C) 2013-2016 CrownSoft
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#ifndef _RFC_KCOMBOBOXLISTENER_H_
#define _RFC_KCOMBOBOXLISTENER_H_


class KComboBox;

class RFC_API KComboBoxListener
{
public:
	KComboBoxListener();
	virtual ~KComboBoxListener();

	virtual void OnComboBoxItemSelect(KComboBox *comboBox);
};

#endif

// =========== KString.h ===========

/*
    RFC - KString.h
    Copyright (C) 2013-2016 CrownSoft
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#ifndef _RFC_KSTRING_H_
#define _RFC_KSTRING_H_

#ifdef _MSC_VER
#define _CRT_SECURE_NO_DEPRECATE
#endif


#include<windows.h>
#include<string.h>
#include<malloc.h>

/**
	Using a reference-counted internal representation, these strings are fast and efficient.
	KString was optimized to use with unicode strings. So, use unicode strings instead of ansi.
	KString does not support for multiple zero terminated strings.
*/
class RFC_API KString
{
	KStringHolder *stringHolder;
public:

	/**
		Constructs an empty string
	*/
	KString();

	/**
		Constructs copy of another string
	*/
	KString(const KString& other);

	/**
		Constructs String object using ansi string
	*/
	KString(const char* const text,UINT codePage=CP_ACP);

	/**
		Constructs String object using unicode string
	*/
	KString(const wchar_t* const text,UINT codePage=CP_ACP);

	/**
		Constructs String object using integer
	*/
	KString(const int value,const int radix);

	/** 
		Replaces this string's contents with another string.
	*/
	const KString& operator= (const KString& other);

	/** 
		Replaces this string's contents with unicode string. 
	*/
	const KString& operator= (const wchar_t* const other);


    /** Appends a string at the end of this one.
        @returns     the concatenated string
    */
	const KString operator+ (const KString& stringToAppend);

    /** Appends a unicode string at the end of this one.
        @returns     the concatenated string
    */
	const KString operator+ (const wchar_t* const textToAppend);
	/**
		Returns ansi version of this string
	*/
	operator const char*()const;

	/**
		Returns unicode version of this string
	*/
	operator const wchar_t*()const;

    /** 
		Returns a character from the string.
		@returns -1 if index is out of range
    */
	const char operator[](const int index)const;

	/**
	    Appends a string at the end of this one.
        @returns     the concatenated string
	*/
	virtual KString Append(const KString& otherString)const;

    /** 
		Returns a subsection of the string.

        If the range specified is beyond the limits of the string, empty string
        will be return.

        @param start   the index of the start of the substring needed
        @param end     all characters from start up to this index are returned
    */
	virtual KString SubString(int start, int end)const;

    /** 
		Case-insensitive comparison with another string.
        @returns     true if the two strings are identical, false if not
    */
	virtual bool EqualsIgnoreCase(const KString& otherString)const;

	/**
		Compare first character with given unicode character
	*/
	virtual bool StartsWithChar(wchar_t character)const;
	/**
		Compare first character with given ansi character
	*/
	virtual bool StartsWithChar(char character)const;

	/**
		Compare last character with given unicode character
	*/
	virtual bool EndsWithChar(wchar_t character)const;

	/**
		Compare last character with given ansi character
	*/
	virtual bool EndsWithChar(char character)const;

	/**
		Check if string is quoted or not
	*/
	virtual bool IsQuotedString()const;

    /** 
		Returns a character from the string.
		@returns -1 if index is out of range
    */
	virtual wchar_t GetCharAt(int index)const;

	/**
		Returns number of characters in string
	*/
	virtual int GetLength()const;

	/**
		Returns true if string is empty
	*/
	virtual bool IsEmpty()const;

	/**
		Returns value of string
	*/
	virtual int GetIntValue()const;

	virtual ~KString();
};

RFC_API const KString operator+ (const char* const string1,const KString& string2);

RFC_API const KString operator+ (const wchar_t* const string1,const KString& string2);

RFC_API const KString operator+ (const KString& string1,const KString& string2);

#endif

// =========== KMenuItem.h ===========

/*
    RFC - KMenuItem.h
    Copyright (C) 2013-2016 CrownSoft
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#ifndef _RFC_KMENUITEM_H_
#define _RFC_KMENUITEM_H_

#include<windows.h>

class KMenuItemListener;

class RFC_API KMenuItem
{
protected:
	HMENU hMenu;
	UINT itemID;
	KMenuItemListener *listener;
	KString itemText;
	bool enabled;
	bool checked;

public:
	KMenuItem();

	virtual void AddToMenu(HMENU hMenu);

	virtual bool IsChecked();

	virtual void SetCheckedState(bool state);

	virtual bool IsEnabled();

	virtual void SetEnabled(bool state);

	virtual void SetText(const KString& text);

	virtual KString GetText();

	virtual UINT GetItemID();

	virtual HMENU GetMenuHandle();

	virtual void SetListener(KMenuItemListener *listener);

	virtual KMenuItemListener* GetListener();

	virtual void OnPress();

	virtual ~KMenuItem();
};

#endif

// =========== KCursor.h ===========

/*
    RFC - KCursor.h
    Copyright (C) 2013-2016 CrownSoft
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#ifndef _RFC_KCURSOR_H_
#define _RFC_KCURSOR_H_

#include<windows.h>

/**
	Can be use to load cursor from file or resource.
*/
class RFC_API KCursor
{
protected:
	HCURSOR hCursor;
	HINSTANCE appInstance;

public:
	KCursor();

	/**
		Loads cursor from resource
		@param resourceID resource ID of cursor file
		@returns false if cursor load fails
	*/
	bool LoadFromResource(WORD resourceID);

	/**
		Loads cursor from file
		@param filePath path to cursor file
		@returns false if cursor load fails
	*/
	bool LoadFromFile(const KString& filePath);

	/**
		Returns cursor handle
	*/
	HCURSOR GetHandle();

	virtual ~KCursor();
};

#endif

// =========== KBitmap.h ===========

/*
    RFC - KBitmap.h
    Copyright (C) 2013-2016 CrownSoft
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#ifndef _RFC_KBITMAP_H_
#define _RFC_KBITMAP_H_

#include<windows.h>

/**
	Can be use to load bitmap image from file or resource.
*/
class RFC_API KBitmap
{
protected:
	HBITMAP hBitmap;
	HINSTANCE appInstance;

public:
	KBitmap();

	/**
		Loads bitmap image from resource
		@param resourceID resource ID of image
		@returns false if image load fails
	*/
	bool LoadFromResource(WORD resourceID);

	/**
		Loads bitmap image from file
		@param filePath path to image
		@returns false if image load fails
	*/
	bool LoadFromFile(const KString& filePath);

	/**
		Returns bitmap handle
	*/
	HBITMAP GetHandle();

	virtual ~KBitmap();
};

#endif


// =========== KIcon.h ===========

/*
    RFC -KIcon.h
    Copyright (C) 2013-2016 CrownSoft
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#ifndef _RFC_KICON_H_
#define _RFC_KICON_H_

#include<windows.h>

/**
	Can be use to load icon from file or resource.
*/
class RFC_API KIcon
{
protected:
	HICON hIcon;
	HINSTANCE appInstance;

public:
	KIcon();

	/**
		Loads icon from resource
		@param resourceID resource ID of icon file
		@returns false if icon load fails
	*/
	bool LoadFromResource(WORD resourceID);

	/**
		Loads icon from file
		@param filePath path to icon file
		@returns false if icon load fails
	*/
	bool LoadFromFile(const KString& filePath);

	/**
		Returns icon handle
	*/
	HICON GetHandle();

	virtual ~KIcon();
};

#endif

// =========== KFont.h ===========

/*
    RFC - KFont.h
    Copyright (C) 2013-2016 CrownSoft
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#ifndef _RFC_KFONT_H_
#define _RFC_KFONT_H_

#include<windows.h>

/**
	Can be use to create system default font or custom font. Once created, you cannot change font properties.
*/
class RFC_API KFont
{
private:
	static KFont* defaultInstance;

protected:
	HFONT hFont;
	bool customFont;

public:
	/**
		Constructs default system Font object.
	*/
	KFont();

	/**
		Constructs custom font object.
	*/
	KFont(const KString& face, int size = 14, bool bold = false, bool italic = false, bool antiAliased=false);

	/**
		If you want to use system default font, then use this static method. Do not delete returned object!
	*/
	static KFont* GetDefaultFont();

	/**
		Returns font handle.
	*/
	virtual HFONT GetFontHandle();

	virtual ~KFont();
};

#endif

// =========== KFile.h ===========

/*
RFC - KFile.h
Copyright (C) 2013-2016 CrownSoft

This software is provided 'as-is', without any express or implied
warranty.  In no event will the authors be held liable for any damages
arising from the use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not
claim that you wrote the original software. If you use this software
in a product, an acknowledgment in the product documentation would be
appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be
misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.

*/

#ifndef _RFC_KFILE_H_
#define _RFC_KFILE_H_

#include<windows.h>

/**
	Can be use to read/write data from a file easily.
*/
class RFC_API KFile
{
protected:
	KString fileName;
	HANDLE fileHandle;
	bool autoCloseHandle;
	DWORD desiredAccess;

public:
	
	KFile();

	/** 
		Used in file opening, to specify whether to open as read or write or both.
	*/
	enum FileAccessTypes
	{
		KREAD = GENERIC_READ,
		KWRITE = GENERIC_WRITE,
		KBOTH = GENERIC_READ | GENERIC_WRITE,
	};

	/** 
		If the file does not exist, it will be created.
	*/
	KFile(const KString& fileName, DWORD desiredAccess = KFile::KBOTH, bool autoCloseHandle = true);

	/** 
		If the file does not exist, it will be created.
	*/
	virtual bool OpenFile(const KString& fileName, DWORD desiredAccess = KFile::KBOTH, bool autoCloseHandle = true);

	virtual bool CloseFile();

	virtual HANDLE GetFileHandle();

	/** 
		fills given buffer and returns number of bytes read.
	*/
	virtual DWORD ReadFile(void* buffer, DWORD numberOfBytesToRead);

	/** 
		You must free the returned buffer yourself. To get the size of buffer, use GetFileSize method. return value will be null on read error.
	*/
	virtual void* ReadAsData();

	virtual KString ReadAsString(bool isUnicode=false);

	/**
		returns number of bytes written.
	*/
	virtual DWORD WriteFile(void* buffer, DWORD numberOfBytesToWrite);

	virtual bool WriteString(const KString& text, bool isUnicode = false);

	virtual bool SetFilePointerToStart();

	virtual bool SetFilePointerToEnd();

	/**
		returns zero on error
	*/
	virtual DWORD GetFileSize();

	static bool DeleteFile(const KString& fileName);

	static bool IsFileExists(const KString& fileName);

	static bool CopyFile(const KString& sourceFileName, const KString& destFileName);

	virtual ~KFile();
};

#endif

// =========== KDirectory.h ===========

/*
RFC - KDirectory.h
Copyright (C) 2013-2016 CrownSoft

This software is provided 'as-is', without any express or implied
warranty.  In no event will the authors be held liable for any damages
arising from the use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not
claim that you wrote the original software. If you use this software
in a product, an acknowledgment in the product documentation would be
appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be
misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.

*/

#ifndef _RFC_KDIRECTORY_H_
#define _RFC_KDIRECTORY_H_

#include<windows.h>

/**
Can be use to manipulate dirs.
*/
class RFC_API KDirectory
{
public:

	KDirectory();

	static bool IsDirExists(const KString& dirName);

	/**
		returns false if dir already exists.
	*/
	static bool CreateDir(const KString& dirName);

	/**
		deletes an existing empty directory.
	*/
	static bool RemoveDir(const KString& dirName);

	/**
		returns parent dir of given module. if HModule is NULL this function will return parent dir of exe.
	*/
	static KString GetParentDir(HMODULE hModule);

	virtual ~KDirectory();
};

#endif

// =========== KApplication.h ===========

/*
    RFC - KApplication.h
    Copyright (C) 2013-2016 CrownSoft
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#ifndef _RFC_KAPPLICATION_H_
#define _RFC_KAPPLICATION_H_


/**
	Derive your application object from this class!
	Override Main method and put your application code there.
	Use START_RFC_APPLICATION macro somewhere in a cpp file to declare an instance of this class.

	e.g. @code
	class MyApp : public KApplication
	{
		public:
			MyApp(){}
			~MyApp(){}

			virtual int Main(KString **argv,int argc)
			{
				// your app code goes here...
				return 0;
			}
	};

	START_RFC_APPLICATION(MyApp)
	@endcode
*/
class RFC_API KApplication
{
public:

	/** 
		Constructs an KApplication object.
	*/
	KApplication();

	/** 
		Called when the application starts.
		Put your application code here and if you create a window, 
		then make sure to call DoMessagePump method before you return.

		@param argv array of command-line arguments! access them like this KString* arg1=argv[0];
		@param argc number of arguments
	*/
	virtual int Main(KString **argv,int argc);

	/** 
		Destructs an Application object.
	*/
	virtual ~KApplication();
};

#endif

// =========== KComponent.h ===========

/*
    RFC - KComponent.h
    Copyright (C) 2013-2016 CrownSoft
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#ifndef _RFC_KCOMPONENT_H_
#define _RFC_KCOMPONENT_H_


#include<windows.h>

/**
	Base class of all W32 gui objects.
*/
class RFC_API KComponent
{
protected:
	KString compClassName;
	KString compText;
	HWND compHWND;
	HWND compParentHWND;
	DWORD compDwStyle;
	DWORD compDwExStyle;
	int compX;
	int compY;
	int compWidth;
	int compHeight;
	bool compVisible;
	bool compEnabled;
	bool isRegistered;
	KFont *compFont;
	KCursor *cursor;

public:
	WNDCLASSEXW wc;

	KComponent();

	/**
		window messages can arrive before this event.
		this method does not update compFont and cursor variables.
		if you override this method, make sure to call parent "OnHotPlug" method first.
	*/
	virtual void OnHotPlug();

	/**
		HotPlugs any given window
	*/
	virtual void HotPlugInto(HWND component);

	/**
		Sets mouse cursor of this component.
	*/
	virtual void SetMouseCursor(KCursor *cursor);

	/**
		@returns autogenerated unique class name for this component
	*/
	virtual KString GetComponentClassName();

	/**
		Registers the class name and creates the component. 
		@returns false if registration failed or component creation failed.
	*/
	virtual bool CreateComponent();

	/**
		Handles windows messages. 
		Important: Pass unprocessed messages to parent if you override this method.
	*/
	virtual LRESULT WindowProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);

	/**
		Sets font of this component
	*/
	virtual void SetFont(KFont *compFont);

	/**
		Returns font of this component
	*/
	virtual KFont* GetFont();

	/**
		Returns caption of this component
	*/
	virtual KString GetText();

	/**
		Sets caption of this component
	*/
	virtual void SetText(const KString& compText);

	virtual void SetHWND(HWND compHWND);

	/**
		Returns HWND of this component
	*/
	virtual HWND GetHWND();

	/**
		Changes parent of this component
	*/
	virtual void SetParentHWND(HWND compParentHWND);

	/**
		Returns parent of this component
	*/
	virtual HWND GetParentHWND();

	/**
		Returns style of this component
	*/
	virtual DWORD GetStyle();

	/**
		Sets style of this component
	*/
	virtual void SetStyle(DWORD compStyle);

	/**
		Returns exstyle of this component
	*/
	virtual DWORD GetExStyle();

	/**
		Sets exstyle of this component
	*/
	virtual void SetExStyle(DWORD compExStyle);

	/**
		Returns x position of this component which is relative to parent component.
	*/
	virtual int GetX();

	/**
		Returns y position of this component which is relative to parent component.
	*/
	virtual int GetY();

	/**
		Returns width of the component.
	*/
	virtual int GetWidth();

	/**
		Returns height of the component.
	*/
	virtual int GetHeight();

	/**
		Sets width and height of the component.
	*/
	virtual void SetSize(int compWidth,int compHeight);

	/**
		Sets x and y position of the component. x and y are relative to parent component
	*/
	virtual void SetPosition(int compX,int compY);

	/**
		Sets visible state of the component
	*/
	virtual void SetVisible(bool state);

	/**
		Returns visible state of the component
	*/
	virtual bool IsVisible();

	/**
		Returns the component is ready for user input or not
	*/
	virtual bool IsEnabled();

	/**
		Sets component's user input reading state
	*/
	virtual void SetEnabled(bool state);

	/**
		Brings component to front
	*/
	virtual void BringToFront();

	/**
		Grabs keyboard focus into this component
	*/
	virtual void SetKeyboardFocus();

	/**
		Repaints the component
	*/
	virtual void Repaint();

	virtual ~KComponent();

};

#endif

// =========== KProgressBar.h ===========

/*
    RFC - KProgressBar.h
    Copyright (C) 2013-2016 CrownSoft
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#ifndef _RFC_KPROGRESSAR_H_
#define _RFC_KPROGRESSAR_H_


class RFC_API KProgressBar : public KComponent
{
protected:
	int value;

public:
	KProgressBar(bool smooth=true,bool vertical=false);

	virtual int GetValue();

	virtual void SetValue(int value);

	virtual bool CreateComponent();

	virtual ~KProgressBar();
};


#endif

// =========== KTextBox.h ===========

/*
    RFC - KTextBox.h
    Copyright (C) 2013-2016 CrownSoft
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#ifndef _RFC_KTEXTBOX_H_
#define _RFC_KTEXTBOX_H_


class RFC_API KTextBox : public KComponent
{
public:
	KTextBox(bool readOnly=false);

	virtual KString GetText();

	virtual bool CreateComponent();

	virtual ~KTextBox();
};

#endif

// =========== KTextArea.h ===========

/*
    RFC - KTextArea.h
    Copyright (C) 2013-2016 CrownSoft
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#ifndef _RFC_KTEXTAREA_H_
#define _RFC_KTEXTAREA_H_


class RFC_API KTextArea : public KTextBox
{
public:
	KTextArea(bool autoScroll=false,bool readOnly=false);

	virtual ~KTextArea();
};


#endif

// =========== KTrackBar.h ===========

/*
    RFC - KTrackBar.h
    Copyright (C) 2013-2016 CrownSoft
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#ifndef _RFC_KTRACKBAR_H_
#define _RFC_KTRACKBAR_H_


class KTrackBarListener;

class RFC_API KTrackBar : public KComponent
{
protected:
	int rangeMin,rangeMax,value;
	KTrackBarListener *listener;

public:
	KTrackBar(bool showTicks=false,bool vertical=false);

	/**
		Range between 0 to 100
	*/
	virtual void SetRange(int min,int max);

	virtual void SetValue(int value);

	virtual int GetValue();

	virtual void SetListener(KTrackBarListener *listener);

	virtual void OnChange();

	virtual bool CreateComponent();

	virtual ~KTrackBar();
};


#endif


// =========== KLabel.h ===========

/*
    RFC - KLabel.h
    Copyright (C) 2013-2016 CrownSoft
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#ifndef _RFC_KLABEL_H_
#define _RFC_KLABEL_H_


class RFC_API KLabel : public KComponent
{
public:
	KLabel();

	virtual bool CreateComponent();

	virtual ~KLabel();
};

#endif

// =========== KButton.h ===========

/*
    RFC - KButton.h
    Copyright (C) 2013-2016 CrownSoft
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#ifndef _RFC_KBUTTON_H_
#define _RFC_KBUTTON_H_


class KButtonListener;

class RFC_API KButton : public KComponent
{
protected:
	KButtonListener *listener;
public:
	KButton();

	virtual void SetListener(KButtonListener *listener);
	virtual KButtonListener* GetListener();

	virtual void OnPress();

	virtual bool CreateComponent();

	virtual ~KButton();
};

#endif

// =========== KCheckBox.h ===========

/*
    RFC - KCheckBox.h
    Copyright (C) 2013-2016 CrownSoft
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#ifndef _RFC_KCHECKBOX_H_
#define _RFC_KCHECKBOX_H_


class RFC_API KCheckBox : public KButton
{
protected:
	bool checked;

public:
	KCheckBox();

	virtual bool CreateComponent();

	virtual void OnPress();

	virtual bool IsChecked();

	virtual void SetCheckedState(bool state);

	virtual ~KCheckBox();
};

#endif

// =========== KGroupBox.h ===========

/*
    RFC - KGroupBox.h
    Copyright (C) 2013-2016 CrownSoft
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#ifndef _RFC_KGROUPBOX_H_
#define _RFC_KGROUPBOX_H_


class RFC_API KGroupBox : public KButton
{
public:
	KGroupBox();

	virtual ~KGroupBox();
};

#endif

// =========== KWindow.h ===========

/*
    RFC - KWindow.h
    Copyright (C) 2013-2016 CrownSoft
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#ifndef _RFC_KWINDOW_H_
#define _RFC_KWINDOW_H_


class RFC_API KWindow : public KComponent
{
public:
	KWindow();

	virtual void SetIcon(KIcon *icon);

	virtual void OnClose();

	virtual void OnDestroy();

	virtual void CenterScreen();

	virtual bool AddComponent(KComponent *component);

	virtual LRESULT WindowProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);

	virtual ~KWindow();
};

#endif

// =========== KListBox.h ===========

/*
    RFC - KListBox.h
    Copyright (C) 2013-2016 CrownSoft
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#ifndef _RFC_KLISTBOX_H_
#define _RFC_KLISTBOX_H_


class KListBoxListener;

class RFC_API KListBox : public KComponent
{
protected:
	KPointerList<KString*> *stringList;
	int selectedItemIndex;
	int selectedItemEnd;
	bool multipleSelection;

	KListBoxListener *listener;

public:
	KListBox(bool multipleSelection=false,bool sort=false,bool vscroll=true);

	virtual void SetListener(KListBoxListener *listener);

	virtual void AddItem(const KString& text);

	virtual void RemoveItem(int index);

	virtual void RemoveItem(const KString& text);

	virtual int GetItemIndex(const KString& text);

	virtual int GetItemCount();

	virtual int GetSelectedItemIndex();

	virtual KString GetSelectedItem();

	virtual int GetSelectedItems(int* itemArray,int itemCountInArray);

	virtual void ClearList();

	virtual void SelectItem(int index);

	virtual void SelectItems(int start,int end);

	virtual bool CreateComponent();

	virtual void OnItemSelect();

	virtual ~KListBox();
};

#endif

// =========== KTimer.h ===========

/*
    RFC - KTimer.h
    Copyright (C) 2013-2016 CrownSoft
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#ifndef _RFC_KTIMER_H_
#define _RFC_KTIMER_H_

#include<windows.h>

/**
    Encapsulates a timer.

    The timer can be started with the StartTimer() method
    and controlled with various other methods. Before you start timer, you must set 
	timer window by calling SetTimerWindow method.
*/
class RFC_API KTimer
{
protected:
	UINT timerID;
	int resolution;
	bool started;
	KWindow *window;
	KTimerListener *listener;

public:

	KTimer();

	/**
		@param resolution timer interval
	*/
	virtual void SetInterval(int resolution);

	virtual int GetInterval();

	/**
		Call this method before you start timer
	*/
	virtual void SetTimerWindow(KWindow *window);

	virtual void SetTimerID(UINT timerID);

	/**
		@returns unique id of this timer
	*/
	virtual UINT GetTimerID();

	/**
		Starts timer
	*/
	virtual void StartTimer();

	/**
		Stops the timer. You can restart it by calling StartTimer() method.
	*/
	virtual void StopTimer();

	virtual void SetListener(KTimerListener *listener);

	virtual bool IsTimerRunning();

	virtual void OnTimer();

	virtual ~KTimer();
};

#endif

// =========== KCommonDialogBox.h ===========

/*
    RFC - KCommonDialogBox.h
    Copyright (C) 2013-2016 CrownSoft
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#ifndef _RFC_KCOMMONDIALOGBOX_H_
#define _RFC_KCOMMONDIALOGBOX_H_


class RFC_API KCommonDialogBox
{
public:
	/**
		Filter string might be like this "Text Files (*.txt)\0*.txt\0"
		You cannot use String object for filter, because filter string contains multiple null characters.
	*/
	static bool ShowOpenFileDialog(KWindow *window, const KString& title, const wchar_t* filter, KString *fileName);

	/**
		Filter string might be like this "Text Files (*.txt)\0*.txt\0"
		You cannot use String object for filter, because filter string contains multiple null characters.
	*/
	static bool ShowSaveFileDialog(KWindow *window, const KString& title, const wchar_t* filter, KString *fileName);
};

#endif

// =========== KComboBox.h ===========

/*
    RFC - KComboBox.h
    Copyright (C) 2013-2016 CrownSoft
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#ifndef _RFC_KCOMBOBOX_H_
#define _RFC_KCOMBOBOX_H_



class KComboBoxListener;

class RFC_API KComboBox : public KComponent
{
protected:
	KPointerList<KString*> *stringList;
	int selectedItemIndex;
	KComboBoxListener *listener;

public:
	KComboBox(bool sort=false);

	virtual void AddItem(const KString& text);

	virtual void RemoveItem(int index);

	virtual void RemoveItem(const KString& text);

	virtual int GetItemIndex(const KString& text);

	virtual int GetItemCount();

	virtual int GetSelectedItemIndex();

	virtual KString GetSelectedItem();

	virtual void ClearList();

	virtual void SelectItem(int index);

	virtual bool CreateComponent();

	virtual void SetListener(KComboBoxListener *listener);

	virtual void OnItemSelect();

	virtual ~KComboBox();
};

#endif

// =========== KMenu.h ===========

/*
    RFC - KMenu.h
    Copyright (C) 2013-2016 CrownSoft
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#ifndef _RFC_KMENU_H_
#define _RFC_KMENU_H_


class RFC_API KMenu
{
protected:
	HMENU hMenu;

public:
	KMenu();

	virtual void AddMenuItem(KMenuItem *menuItem);

	virtual void AddSubMenu(const KString& text, KMenu *menu);

	virtual void AddSeperator();

	virtual HMENU GetMenuHandle();

	virtual void PopUpMenu(KWindow *window);

	virtual ~KMenu();
};

#endif

// =========== KPlatformUtil.h ===========

/*
    RFC - KPlatformUtil.h
    Copyright (C) 2013-2016 CrownSoft
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#ifndef _RFC_KPLATFORMUTIL_H_
#define _RFC_KPLATFORMUTIL_H_

#include<windows.h>
#include<stdio.h>

/**
	Singleton class which can be use to get HINSTANCE of your application.
	e.g. @code
	HINSTANCE hInstance=PlatformUtil::GetInstance()->GetAppInstance();
	@endcode
*/
class RFC_API KPlatformUtil
{
private:

	static KPlatformUtil *_instance;

	KPlatformUtil();

protected:
	HINSTANCE hInstance;
	CRITICAL_SECTION g_csCount;
	int classCount;
	int timerCount;
	UINT menuItemCount;

	KPointerList<KMenuItem*> *menuItemList;
	KPointerList<KTimer*> *timerList;

public:

	static KPlatformUtil* GetInstance();

	void SetAppInstance(HINSTANCE hInstance);

	HINSTANCE GetAppInstance();

	KString GenerateClassName();
	UINT GenerateMenuItemID(KMenuItem *menuItem);
	KMenuItem* GetMenuItemByID(UINT id);

	UINT GenerateTimerID(KTimer *timer);
	KTimer* GetTimerByID(UINT id);

	~KPlatformUtil();

};


#endif

// =========== KPasswordBox.h ===========

/*
    RFC - KPasswordBox.h
    Copyright (C) 2013-2016 CrownSoft
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#ifndef _RFC_KPASSWORDBOX_H_
#define _RFC_KPASSWORDBOX_H_


class RFC_API KPasswordBox : public KTextBox
{
protected:
	char pwdChar;

public:
	KPasswordBox(bool readOnly=false);

	virtual void SetPasswordChar(const char pwdChar);

	virtual char GetPasswordChar();

	virtual bool CreateComponent();

	virtual ~KPasswordBox();
};

#endif

// =========== KRadioButton.h ===========

/*
    RFC - KRadioButton.h
    Copyright (C) 2013-2016 CrownSoft
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#ifndef _RFC_KRADIOBUTTON_H_
#define _RFC_KRADIOBUTTON_H_


class RFC_API KRadioButton : public KCheckBox
{
public:
	KRadioButton();

	virtual ~KRadioButton();
};

#endif

// =========== KPushButton.h ===========

/*
    RFC - KPushButton.h
    Copyright (C) 2013-2016 CrownSoft
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#ifndef _RFC_KPUSHBUTTON_H_
#define _RFC_KPUSHBUTTON_H_


class RFC_API KPushButton : public KCheckBox
{
public:
	KPushButton();

	virtual ~KPushButton();
};

#endif

// =========== KNumericField.h ===========

/*
    RFC - KNumericField.h
    Copyright (C) 2013-2016 CrownSoft
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#ifndef _RFC_KNUMERICFIELD_H_
#define _RFC_KNUMERICFIELD_H_


class RFC_API KNumericField : public KTextBox
{
public:
	KNumericField();

	virtual ~KNumericField();
};

#endif

// =========== KWindowTypes.h ===========

/*
    RFC - KWindowTypes.h
    Copyright (C) 2013-2016 CrownSoft
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#ifndef _RFC_KWINDOWTYPES_H_
#define _RFC_KWINDOWTYPES_H_


class RFC_API KHotPluggedDialog : public KWindow
{
public:
	KHotPluggedDialog();

	virtual void OnClose();
	virtual void OnDestroy();

	virtual ~KHotPluggedDialog();
};

class RFC_API KOverlappedWindow : public KWindow
{
public:
	KOverlappedWindow();

	virtual ~KOverlappedWindow();
};

class RFC_API KFrame : public KWindow
{
public:
	KFrame();

	virtual ~KFrame();
};

class RFC_API KDialog : public KWindow
{
public:
	KDialog();

	virtual ~KDialog();
};

class RFC_API KToolWindow : public KWindow
{
public:
	KToolWindow();

	virtual ~KToolWindow();
};

#endif

// =========== KMenuBar.h ===========

/*
    RFC - KMenuBar.h
    Copyright (C) 2013-2016 CrownSoft
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#ifndef _RFC_KMENUBAR_H_
#define _RFC_KMENUBAR_H_


class RFC_API KMenuBar
{
protected:
	HMENU hMenu;

public:
	KMenuBar();

	virtual void AddMenu(const KString& text, KMenu *menu);

	virtual void AddToWindow(KWindow *window);

	virtual ~KMenuBar();
};


#endif

// =========== rfc.h ===========

/*
    RFC Framework v0.2.5
    Copyright (C) 2013-2016 CrownSoft
  
    This software is provided 'as-is', without any express or implied
    warranty.  In no event will the authors be held liable for any damages
    arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute it
    freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
       claim that you wrote the original software. If you use this software
       in a product, an acknowledgment in the product documentation would be
       appreciated but is not required.
    2. Altered source versions must be plainly marked as such, and must not be
       misrepresented as being the original software.
    3. This notice may not be removed or altered from any source distribution.
      
*/

#ifndef _RFC_H_
#define _RFC_H_

#ifndef _WIN32_IE
#define _WIN32_IE 0X0300 // this will allow to use INITCOMMONCONTROLSEX on MinGW
#endif

#include<windows.h>
#include<commctrl.h>

#ifdef _MSC_VER
#pragma comment(lib,"Comctl32.lib")
#endif



RFC_API LRESULT CALLBACK GlobalWnd_Proc(HWND,UINT,WPARAM,LPARAM);
RFC_API INT_PTR CALLBACK GlobalDlg_Proc(HWND, UINT, WPARAM, LPARAM);
RFC_API DWORD WINAPI GlobalThread_Proc(LPVOID);

RFC_API HWND CreateRFCComponent(KComponent*);
RFC_API bool CreateRFCThread(KThread*);

RFC_API void DoMessagePump(bool handleTabKey=true);

RFC_API void InitRFC(HINSTANCE);
RFC_API void DeInitRFC();

RFC_API int HotPlugAndRunDialogBox(WORD resourceID,HWND parentHwnd,KComponent* component);

#define START_RFC_APPLICATION(AppClass) \
int WINAPI WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nCmdShow) \
{ \
	InitRFC(hInstance);\
	int argc=0;\
	LPWSTR *args=CommandLineToArgvW(GetCommandLineW(),&argc);\
	KString **str_argv = (KString**)malloc(argc*PTR_SIZE); \
	for(int i=0;i<argc;i++){str_argv[i]=new KString(args[i]);}\
	AppClass* application=new AppClass();\
	int retVal=application->Main(str_argv,argc);\
	delete application;\
	DeInitRFC();\
	for(int i=0;i<argc;i++){delete str_argv[i];}\
	free((void*)str_argv);\
	GlobalFree(args);\
	return retVal;\
}

// use this macro if you are not using commandline arguments in your app.
#define START_RFC_APPLICATION_NO_CMD_ARGS(AppClass) \
int WINAPI WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nCmdShow) \
{ \
	InitRFC(hInstance);\
	AppClass* application=new AppClass();\
	int retVal=application->Main(0,0);\
	delete application;\
	DeInitRFC();\
	return retVal;\
}

// require to support XP/Vista styles.
#ifdef _MSC_VER
	#ifndef RFC_DLL
		#ifndef RFC_NO_MANIFEST
			#ifdef RFC64
				#pragma comment(linker,"/manifestdependency:\"type='win32' name='Microsoft.Windows.Common-Controls' version='6.0.0.0' processorArchitecture='amd64' publicKeyToken='6595b64144ccf1df' language='*'\"")
			#else
				#pragma comment(linker,"/manifestdependency:\"type='win32' name='Microsoft.Windows.Common-Controls' version='6.0.0.0' processorArchitecture='x86' publicKeyToken='6595b64144ccf1df' language='*'\"")
			#endif
		#endif
	#endif
#endif

#define BEGIN_KMSG_HANDLER \
	virtual LRESULT WindowProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam) \
	{\
	switch(msg)\
	{

#define ON_KMSG(_KMsg,_KMsgHandler) \
	case _KMsg: return _KMsgHandler(wParam,lParam);

#define END_KMSG_HANDLER(_KComponentParentClass) \
	default: return _KComponentParentClass::WindowProc(hwnd,msg,wParam,lParam); \
	}\
	}




#endif

#endif

